/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.login.controller;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.extra.servlet.ServletUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.login.domain.LoginForm;
import net.lab1024.sa.admin.module.system.login.domain.LoginResultVO;
import net.lab1024.sa.admin.module.system.login.domain.RegisterForm;
import net.lab1024.sa.admin.module.system.login.service.LoginService;
import net.lab1024.sa.admin.util.AdminRequestUtil;
import net.lab1024.sa.base.common.annoation.NoNeedLogin;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.module.support.captcha.domain.CaptchaVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u5458\u5de5\u767b\u5f55")
public class LoginController {
    @Resource
    private LoginService loginService;

    @NoNeedLogin
    @PostMapping(value={"/login"})
    @Operation(summary="\u767b\u5f55 @author \u5353\u5927")
    public ResponseDTO<LoginResultVO> login(@Valid @RequestBody LoginForm loginForm, HttpServletRequest request) {
        String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String userAgent = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)"user-agent");
        return this.loginService.login(loginForm, ip, userAgent);
    }

    @NoNeedLogin
    @PostMapping(value={"/loginForPublic"})
    @Operation(summary="\u767b\u5f55 ")
    public ResponseDTO<LoginResultVO> loginForPublic(@Valid @RequestBody LoginForm loginForm, HttpServletRequest request) {
        String ip = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        String userAgent = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)"user-agent");
        return this.loginService.loginForPublic(loginForm, ip, userAgent);
    }

    @NoNeedLogin
    @PostMapping(value={"/getLoginFirst"})
    @Operation(summary="\u68c0\u6d4b\u662f\u5426\u7b2c\u4e00\u6b21\u767b\u5f55 ")
    public ResponseDTO<LoginResultVO> loginForFirst() {
        return this.loginService.getLoginFirst();
    }

    @NoNeedLogin
    @PostMapping(value={"/registerForPublic"})
    @Operation(summary="\u6ce8\u518c ")
    public ResponseDTO<LoginResultVO> registerForPublic(@RequestBody RegisterForm registerForm) {
        return this.loginService.registerForPublic(registerForm);
    }

    @GetMapping(value={"/login/getLoginInfo"})
    @Operation(summary="\u83b7\u53d6\u767b\u5f55\u7ed3\u679c\u4fe1\u606f  @author \u5353\u5927")
    public ResponseDTO<LoginResultVO> getLoginInfo() {
        LoginResultVO loginResult = this.loginService.getLoginResult(AdminRequestUtil.getRequestUser());
        String tokenValue = StpUtil.getTokenValue();
        loginResult.setToken(tokenValue);
        return ResponseDTO.ok((Object)loginResult);
    }

    @Operation(summary="\u9000\u51fa\u767b\u9646  @author \u5353\u5927")
    @GetMapping(value={"/login/logout"})
    public ResponseDTO<String> logout(@RequestHeader(value="x-access-token", required=false) String token) {
        return this.loginService.logout(token, SmartRequestUtil.getRequestUser());
    }

    @Operation(summary="\u83b7\u53d6\u9a8c\u8bc1\u7801  @author \u5353\u5927")
    @GetMapping(value={"/login/getCaptcha"})
    @NoNeedLogin
    public ResponseDTO<CaptchaVO> getCaptcha() {
        return this.loginService.getCaptcha();
    }

    @NoNeedLogin
    @PostMapping(value={"/login/getVerificationCode"})
    @Operation(summary="\u83b7\u53d6\u624b\u673a\u53f7\u767b\u5f55\u9a8c\u8bc1\u7801")
    public ResponseDTO<LoginResultVO> getVerificationCode(@RequestBody LoginForm loginForm) {
        return this.loginService.getVerificationCode(loginForm);
    }

    @NoNeedLogin
    @PostMapping(value={"/login/getVerificationCodeForRegister"})
    @Operation(summary="\u83b7\u53d6\u624b\u673a\u53f7\u6ce8\u518c\u9a8c\u8bc1\u7801")
    public ResponseDTO<LoginResultVO> getVerificationCodeForRegister(@RequestBody RegisterForm registerForm) {
        return this.loginService.getVerificationCodeForRegister(registerForm);
    }

    @NoNeedLogin
    @PostMapping(value={"/loginByPhone"})
    @Operation(summary="\u624b\u673a\u53f7\u767b\u9646")
    public ResponseDTO<LoginResultVO> loginByPhone(@RequestBody LoginForm loginForm) {
        return this.loginService.loginByPhone(loginForm);
    }
}

