/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.login.service;

import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.extra.servlet.ServletUtil;
import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.teaopenapi.models.Config;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.lab1024.sa.admin.module.system.department.domain.vo.DepartmentVO;
import net.lab1024.sa.admin.module.system.department.service.DepartmentService;
import net.lab1024.sa.admin.module.system.employee.domain.entity.EmployeeEntity;
import net.lab1024.sa.admin.module.system.employee.domain.form.EmployeeAddForm;
import net.lab1024.sa.admin.module.system.employee.manager.EmployeeManager;
import net.lab1024.sa.admin.module.system.employee.service.EmployeeService;
import net.lab1024.sa.admin.module.system.login.domain.KeyInfo;
import net.lab1024.sa.admin.module.system.login.domain.LoginForm;
import net.lab1024.sa.admin.module.system.login.domain.LoginResultVO;
import net.lab1024.sa.admin.module.system.login.domain.PublicUserInfo;
import net.lab1024.sa.admin.module.system.login.domain.RegisterForm;
import net.lab1024.sa.admin.module.system.login.domain.RequestEmployee;
import net.lab1024.sa.admin.module.system.login.utils.PublicLogin;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuVO;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleVO;
import net.lab1024.sa.admin.module.system.role.service.RoleEmployeeService;
import net.lab1024.sa.admin.module.system.role.service.RoleMenuService;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.UserPermission;
import net.lab1024.sa.base.common.enumeration.UserTypeEnum;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartEnumUtil;
import net.lab1024.sa.base.common.util.SmartIpUtil;
import net.lab1024.sa.base.constant.LoginDeviceEnum;
import net.lab1024.sa.base.module.support.captcha.CaptchaService;
import net.lab1024.sa.base.module.support.captcha.domain.CaptchaForm;
import net.lab1024.sa.base.module.support.captcha.domain.CaptchaVO;
import net.lab1024.sa.base.module.support.config.ConfigKeyEnum;
import net.lab1024.sa.base.module.support.config.ConfigService;
import net.lab1024.sa.base.module.support.file.service.IFileStorageService;
import net.lab1024.sa.base.module.support.loginlog.LoginLogResultEnum;
import net.lab1024.sa.base.module.support.loginlog.LoginLogService;
import net.lab1024.sa.base.module.support.loginlog.domain.LoginLogEntity;
import net.lab1024.sa.base.module.support.loginlog.domain.LoginLogVO;
import net.lab1024.sa.base.module.support.securityprotect.domain.LoginFailEntity;
import net.lab1024.sa.base.module.support.securityprotect.service.ProtectLoginService;
import net.lab1024.sa.base.module.support.securityprotect.service.ProtectPasswordService;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LoginService
implements StpInterface {
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private static final String SUPER_PASSWORD_LOGIN_ID_PREFIX = "S";
    private static final long CACHE_MAX_ONLINE_PERSON_COUNT = 1000L;
    private final ConcurrentMap<Long, RequestEmployee> loginEmployeeCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1000L).build();
    @Resource
    private EmployeeManager employeeManager;
    private final ConcurrentMap<Long, UserPermission> permissionCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1000L).build();
    @Resource
    private EmployeeService employeeService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private CaptchaService captchaService;
    @Resource
    private ConfigService configService;
    @Resource
    private LoginLogService loginLogService;
    @Resource
    private RoleEmployeeService roleEmployeeService;
    @Resource
    private RoleMenuService roleMenuService;
    @Resource
    private ProtectLoginService protectLoginService;
    @Resource
    private ProtectPasswordService profectPasswordService;
    @Resource
    private IFileStorageService fileStorageService;

    public ResponseDTO<CaptchaVO> getCaptcha() {
        return ResponseDTO.ok((Object)this.captchaService.generateCaptcha());
    }

    public ResponseDTO<LoginResultVO> login(LoginForm loginForm, String ip, String userAgent) {
        LoginDeviceEnum loginDeviceEnum = (LoginDeviceEnum)SmartEnumUtil.getEnumByValue((Object)loginForm.getLoginDevice(), LoginDeviceEnum.class);
        if (loginDeviceEnum == null) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u8bbe\u5907\u6682\u4e0d\u652f\u6301\uff01");
        }
        ResponseDTO checkCaptcha = this.captchaService.checkCaptcha((CaptchaForm)loginForm);
        if (!checkCaptcha.getOk().booleanValue()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.PARAM_ERROR, (String)checkCaptcha.getMsg());
        }
        EmployeeEntity employeeEntity = this.employeeService.getByLoginName(loginForm.getLoginName());
        if (null == employeeEntity) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u4e0d\u5b58\u5728\uff01");
        }
        if (employeeEntity.getDisabledFlag().booleanValue()) {
            this.saveLoginLog(employeeEntity, ip, userAgent, "\u8d26\u53f7\u5df2\u7981\u7528", LoginLogResultEnum.LOGIN_FAIL);
            return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u7981\u7528,\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458\uff01");
        }
        String requestPassword = this.profectPasswordService.decryptPassword(loginForm.getPassword());
        String superPassword = this.configService.getConfigValue(ConfigKeyEnum.SUPER_PASSWORD);
        boolean superPasswordFlag = superPassword.equals(requestPassword);
        if (superPasswordFlag) {
            String saTokenLoginId = "S:" + UUID.randomUUID().toString().replace("-", "") + ":" + employeeEntity.getEmployeeId();
            StpUtil.login((Object)saTokenLoginId, (long)1800L);
        } else {
            ResponseDTO loginFailEntityResponseDTO = this.protectLoginService.checkLogin(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
            if (!loginFailEntityResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.error((ResponseDTO)loginFailEntityResponseDTO);
            }
            if (!employeeEntity.getLoginPwd().equals(EmployeeService.getEncryptPwd((String)requestPassword))) {
                this.saveLoginLog(employeeEntity, ip, userAgent, "\u5bc6\u7801\u9519\u8bef", LoginLogResultEnum.LOGIN_FAIL);
                String msg = this.protectLoginService.recordLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE, employeeEntity.getLoginName(), (LoginFailEntity)loginFailEntityResponseDTO.getData());
                return msg == null ? ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01") : ResponseDTO.error((ErrorCode)UserErrorCode.LOGIN_FAIL_WILL_LOCK, (String)msg);
            }
            String saTokenLoginId = UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeEntity.getEmployeeId();
            StpUtil.login((Object)saTokenLoginId, (String)String.valueOf(loginDeviceEnum.getDesc()));
        }
        RequestEmployee requestEmployee = this.loadLoginInfo(employeeEntity);
        this.loginEmployeeCache.put(employeeEntity.getEmployeeId(), requestEmployee);
        this.protectLoginService.removeLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
        LoginResultVO loginResultVO = this.getLoginResult(requestEmployee);
        this.saveLoginLog(employeeEntity, ip, userAgent, superPasswordFlag ? "\u4e07\u80fd\u5bc6\u7801\u767b\u5f55" : loginDeviceEnum.getDesc(), LoginLogResultEnum.LOGIN_SUCCESS);
        loginResultVO.setToken(StpUtil.getTokenValue());
        this.permissionCache.remove(employeeEntity.getEmployeeId());
        return ResponseDTO.ok((Object)loginResultVO);
    }

    public ResponseDTO<LoginResultVO> loginForPublic(LoginForm loginForm, String ip, String userAgent) {
        LoginDeviceEnum loginDeviceEnum = (LoginDeviceEnum)SmartEnumUtil.getEnumByValue((Object)loginForm.getLoginDevice(), LoginDeviceEnum.class);
        if (loginDeviceEnum == null) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u8bbe\u5907\u6682\u4e0d\u652f\u6301\uff01");
        }
        ResponseDTO checkCaptcha = this.captchaService.checkCaptcha((CaptchaForm)loginForm);
        if (!checkCaptcha.getOk().booleanValue()) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.PARAM_ERROR, (String)checkCaptcha.getMsg());
        }
        EmployeeEntity employeeEntity_l = this.employeeService.getByLoginName(loginForm.getLoginName());
        if (null != employeeEntity_l) {
            if (employeeEntity_l.getBlockingTime().compareTo(LocalDateTime.now()) < 0) {
                return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39\u4e4b\u540e\u4f7f\u7528\uff01");
            }
        } else if (null == employeeEntity_l) {
            if (this.employeeService.getById(Long.valueOf(2L)) != null) {
                return ResponseDTO.userErrorParam((String)"\u8be5\u8bbe\u5907\u5df2\u6709\u8d26\u53f7\uff0c\u6bcf\u8bbe\u5907\u4ec5\u53ef\u767b\u5f55\u4e00\u4e2a\u8d26\u53f7\uff0c\u8bf7\u6362\u8bbe\u5907\u540e\u767b\u5f55\uff01");
            }
            ResponseDTO publicUserInfo = PublicLogin.queryPublicUserInfo(null, (String)loginForm.getLoginName());
            if (!publicUserInfo.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)publicUserInfo.getMsg());
            }
            PublicUserInfo publicUserInfoEntity = (PublicUserInfo)publicUserInfo.getData();
            String userStatus = String.valueOf(publicUserInfoEntity.getUserStatus());
            if (userStatus.equals("1")) {
                return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u7981\u7528,\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458\uff01");
            }
            String bindStatus = String.valueOf(publicUserInfoEntity.getBindStatus());
            if (bindStatus.equals("1")) {
                return ResponseDTO.userErrorParam((String)"\u8be5\u8d26\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8bbe\u5907");
            }
            EmployeeAddForm employeeAddForm = new EmployeeAddForm();
            employeeAddForm.setActualName(publicUserInfoEntity.getUserName());
            employeeAddForm.setDepartmentId(Long.valueOf(5L));
            employeeAddForm.setDisabledFlag(Boolean.FALSE);
            employeeAddForm.setGender(Integer.valueOf(1));
            employeeAddForm.setLoginName(publicUserInfoEntity.getLoginName());
            employeeAddForm.setPhone(publicUserInfoEntity.getLoginPhone());
            ArrayList<Long> roleIdList = new ArrayList<Long>();
            roleIdList.add(58L);
            employeeAddForm.setRoleIdList(roleIdList);
            employeeAddForm.setBlockingTime(publicUserInfoEntity.getBlockingTime());
            employeeAddForm.setPayUser(Boolean.TRUE.booleanValue());
            ResponseDTO stringResponseDTO = this.employeeService.addEmployeeByPassword(employeeAddForm, publicUserInfoEntity.getLoginPassword());
            if (!stringResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)stringResponseDTO.getMsg());
            }
            ResponseDTO infoResponseDTO = PublicLogin.UpdatePublicUserInfo(null, (String)publicUserInfoEntity.getLoginName());
            if (!infoResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)infoResponseDTO.getMsg());
            }
        }
        EmployeeEntity employeeEntity = this.employeeService.getByLoginName(loginForm.getLoginName());
        String requestPassword = this.profectPasswordService.decryptPassword(loginForm.getPassword());
        String superPassword = this.configService.getConfigValue(ConfigKeyEnum.SUPER_PASSWORD);
        boolean superPasswordFlag = superPassword.equals(requestPassword);
        if (superPasswordFlag) {
            String saTokenLoginId = "S:" + UUID.randomUUID().toString().replace("-", "") + ":" + employeeEntity.getEmployeeId();
            StpUtil.login((Object)saTokenLoginId, (long)1800L);
        } else {
            ResponseDTO loginFailEntityResponseDTO = this.protectLoginService.checkLogin(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
            if (!loginFailEntityResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.error((ResponseDTO)loginFailEntityResponseDTO);
            }
            if (!employeeEntity.getLoginPwd().equals(EmployeeService.getEncryptPwd((String)requestPassword))) {
                this.saveLoginLog(employeeEntity, ip, userAgent, "\u5bc6\u7801\u9519\u8bef", LoginLogResultEnum.LOGIN_FAIL);
                String msg = this.protectLoginService.recordLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE, employeeEntity.getLoginName(), (LoginFailEntity)loginFailEntityResponseDTO.getData());
                return msg == null ? ResponseDTO.userErrorParam((String)"\u767b\u5f55\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01") : ResponseDTO.error((ErrorCode)UserErrorCode.LOGIN_FAIL_WILL_LOCK, (String)msg);
            }
            String saTokenLoginId = UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeEntity.getEmployeeId();
            StpUtil.login((Object)saTokenLoginId, (String)String.valueOf(loginDeviceEnum.getDesc()));
        }
        RequestEmployee requestEmployee = this.loadLoginInfo(employeeEntity);
        this.loginEmployeeCache.put(employeeEntity.getEmployeeId(), requestEmployee);
        this.protectLoginService.removeLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
        LoginResultVO loginResultVO = this.getLoginResult(requestEmployee);
        this.saveLoginLog(employeeEntity, ip, userAgent, superPasswordFlag ? "\u4e07\u80fd\u5bc6\u7801\u767b\u5f55" : loginDeviceEnum.getDesc(), LoginLogResultEnum.LOGIN_SUCCESS);
        this.updateLoginFirstInfo(employeeEntity.getEmployeeId(), true);
        loginResultVO.setToken(StpUtil.getTokenValue());
        this.permissionCache.remove(employeeEntity.getEmployeeId());
        return ResponseDTO.ok((Object)loginResultVO);
    }

    public ResponseDTO<LoginResultVO> getLoginFirst() {
        EmployeeEntity employeeEntity = this.employeeService.getById(Long.valueOf(2L));
        System.out.println(employeeEntity);
        if (employeeEntity != null) {
            if (employeeEntity.getBlockingTime().compareTo(LocalDateTime.now()) < 0) {
                return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39\u4e4b\u540e\u4f7f\u7528\uff01");
            }
            if (!employeeEntity.getPayUser().booleanValue()) {
                return null;
            }
        } else {
            return null;
        }
        String saTokenLoginId = UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeEntity.getEmployeeId();
        LoginDeviceEnum loginDeviceEnum = (LoginDeviceEnum)SmartEnumUtil.getEnumByValue((Object)1, LoginDeviceEnum.class);
        StpUtil.login((Object)saTokenLoginId, (String)String.valueOf(loginDeviceEnum.getDesc()));
        RequestEmployee requestEmployee = this.loadLoginInfo(employeeEntity);
        this.loginEmployeeCache.put(employeeEntity.getEmployeeId(), requestEmployee);
        this.protectLoginService.removeLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
        LoginResultVO loginResultVO = this.getLoginResult(requestEmployee);
        loginResultVO.setToken(StpUtil.getTokenValue());
        this.permissionCache.remove(employeeEntity.getEmployeeId());
        return ResponseDTO.ok((Object)loginResultVO);
    }

    private boolean isPhoneNumber(String str) {
        return str.matches("^1\\d{10}$");
    }

    private boolean isUsername(String str) {
        return str.matches("^[a-zA-Z].*$");
    }

    public LoginResultVO getLoginResult(RequestEmployee requestEmployee) {
        LoginResultVO loginResultVO = (LoginResultVO)SmartBeanUtil.copy((Object)requestEmployee, LoginResultVO.class);
        List roleList = this.roleEmployeeService.getRoleIdList(requestEmployee.getEmployeeId());
        List menuAndPointsList = this.roleMenuService.getMenuList(roleList.stream().map(RoleVO::getRoleId).collect(Collectors.toList()), requestEmployee.getAdministratorFlag());
        loginResultVO.setMenuList(menuAndPointsList);
        UserPermission userPermission = this.getUserPermission(requestEmployee.getUserId());
        this.permissionCache.put(requestEmployee.getUserId(), userPermission);
        LoginLogVO loginLogVO = this.loginLogService.queryLastByUserId(requestEmployee.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE, LoginLogResultEnum.LOGIN_SUCCESS);
        if (loginLogVO != null) {
            loginResultVO.setLastLoginIp(loginLogVO.getLoginIp());
            loginResultVO.setLastLoginIpRegion(loginLogVO.getLoginIpRegion());
            loginResultVO.setLastLoginTime(loginLogVO.getCreateTime());
            loginResultVO.setLastLoginUserAgent(loginLogVO.getUserAgent());
        }
        return loginResultVO;
    }

    private RequestEmployee loadLoginInfo(EmployeeEntity employeeEntity) {
        ResponseDTO getFileUrl;
        RequestEmployee requestEmployee = (RequestEmployee)SmartBeanUtil.copy((Object)employeeEntity, RequestEmployee.class);
        requestEmployee.setUserType(UserTypeEnum.ADMIN_EMPLOYEE);
        DepartmentVO department = this.departmentService.getDepartmentById(employeeEntity.getDepartmentId());
        requestEmployee.setDepartmentName(null == department ? "" : department.getName());
        String avatar = employeeEntity.getAvatar();
        if (StringUtils.isNotBlank((CharSequence)avatar) && BooleanUtils.isTrue((Boolean)(getFileUrl = this.fileStorageService.getFileUrl(avatar)).getOk())) {
            requestEmployee.setAvatar((String)getFileUrl.getData());
        }
        return requestEmployee;
    }

    public RequestEmployee getLoginEmployee(String loginId, HttpServletRequest request) {
        if (loginId == null) {
            return null;
        }
        Long requestEmployeeId = this.getEmployeeIdByLoginId(loginId);
        if (requestEmployeeId == null) {
            return null;
        }
        RequestEmployee requestEmployee = (RequestEmployee)this.loginEmployeeCache.get(requestEmployeeId);
        if (requestEmployee == null) {
            EmployeeEntity employeeEntity = this.employeeService.getById(requestEmployeeId);
            if (employeeEntity == null) {
                return null;
            }
            requestEmployee = this.loadLoginInfo(employeeEntity);
            this.loginEmployeeCache.put(requestEmployeeId, requestEmployee);
        }
        requestEmployee.setUserAgent(ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)"user-agent"));
        requestEmployee.setIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        return requestEmployee;
    }

    Long getEmployeeIdByLoginId(String loginId) {
        if (loginId == null) {
            return null;
        }
        try {
            String employeeIdStr = null;
            employeeIdStr = loginId.startsWith("S") ? loginId.split(":")[2] : loginId.substring(2);
            return Long.parseLong(employeeIdStr);
        }
        catch (Exception e) {
            log.error("loginId parse error , loginId : {}", (Object)loginId, (Object)e);
            return null;
        }
    }

    public ResponseDTO<String> logout(String token, RequestUser requestUser) {
        StpUtil.logoutByTokenValue((String)token);
        this.loginEmployeeCache.remove(requestUser.getUserId());
        this.updateLoginFirstInfo(requestUser.getUserId(), false);
        LoginLogEntity loginEntity = LoginLogEntity.builder().userId(requestUser.getUserId()).userType(requestUser.getUserType().getValue()).userName(requestUser.getUserName()).userAgent(requestUser.getUserAgent()).loginIp(requestUser.getIp()).loginIpRegion(SmartIpUtil.getRegion((String)requestUser.getIp())).loginResult(LoginLogResultEnum.LOGIN_OUT.getValue()).createTime(LocalDateTime.now()).build();
        this.loginLogService.log(loginEntity);
        return ResponseDTO.ok();
    }

    public void updateLoginFirstInfo(Long userId, boolean flag) {
        EmployeeEntity employeeEntity = this.employeeService.getById(userId);
        employeeEntity.setLoginPwd(null);
        employeeEntity.setPayUser(Boolean.valueOf(flag));
        this.employeeManager.updateEmployee(employeeEntity, null);
        this.clearLoginEmployeeCache(Long.valueOf(2L));
    }

    public void clearLoginEmployeeCache(Long employeeId) {
        this.loginEmployeeCache.remove(employeeId);
    }

    private void saveLoginLog(EmployeeEntity employeeEntity, String ip, String userAgent, String remark, LoginLogResultEnum result) {
        LoginLogEntity loginEntity = LoginLogEntity.builder().userId(employeeEntity.getEmployeeId()).userType(UserTypeEnum.ADMIN_EMPLOYEE.getValue()).userName(employeeEntity.getActualName()).userAgent(userAgent).loginIp(ip).loginIpRegion(SmartIpUtil.getRegion((String)ip)).remark(remark).loginResult(result.getValue()).createTime(LocalDateTime.now()).build();
        this.loginLogService.log(loginEntity);
    }

    public List<String> getPermissionList(Object loginId, String loginType) {
        Long employeeId = this.getEmployeeIdByLoginId((String)loginId);
        if (employeeId == null) {
            return Collections.emptyList();
        }
        UserPermission userPermission = (UserPermission)this.permissionCache.get(employeeId);
        if (userPermission == null) {
            userPermission = this.getUserPermission(employeeId);
            this.permissionCache.put(employeeId, userPermission);
        }
        return userPermission.getPermissionList();
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        Long employeeId = this.getEmployeeIdByLoginId((String)loginId);
        if (employeeId == null) {
            return Collections.emptyList();
        }
        UserPermission userPermission = (UserPermission)this.permissionCache.get(employeeId);
        if (userPermission == null) {
            userPermission = this.getUserPermission(employeeId);
            this.permissionCache.put(employeeId, userPermission);
        }
        return userPermission.getRoleList();
    }

    private UserPermission getUserPermission(Long employeeId) {
        UserPermission userPermission = new UserPermission();
        userPermission.setPermissionList(new ArrayList());
        userPermission.setRoleList(new ArrayList());
        List roleList = this.roleEmployeeService.getRoleIdList(employeeId);
        userPermission.getRoleList().addAll(roleList.stream().map(RoleVO::getRoleCode).collect(Collectors.toSet()));
        EmployeeEntity employeeEntity = this.employeeService.getById(employeeId);
        List menuAndPointsList = this.roleMenuService.getMenuList(roleList.stream().map(RoleVO::getRoleId).collect(Collectors.toList()), employeeEntity.getAdministratorFlag());
        HashSet<String> permissionSet = new HashSet<String>();
        for (MenuVO menu : menuAndPointsList) {
            String perms;
            if (menu.getPermsType() == null || StringUtils.isEmpty((CharSequence)(perms = menu.getApiPerms()))) continue;
            String[] split = perms.split(",");
            permissionSet.addAll(Arrays.asList(split));
        }
        userPermission.getPermissionList().addAll(permissionSet);
        return userPermission;
    }

    public ResponseDTO<LoginResultVO> loginByPhone(LoginForm loginForm) {
        LoginDeviceEnum loginDeviceEnum = (LoginDeviceEnum)SmartEnumUtil.getEnumByValue((Object)loginForm.getLoginDevice(), LoginDeviceEnum.class);
        String code = loginForm.getVerificationCode();
        String phone = loginForm.getPhoneNumber();
        if (loginDeviceEnum == null) {
            return ResponseDTO.userErrorParam((String)"\u767b\u5f55\u8bbe\u5907\u6682\u4e0d\u652f\u6301\uff01");
        }
        String rightCode = (String)this.redisTemplate.opsForValue().get((Object)("PHONE_" + phone));
        if (!code.equals(rightCode)) {
            return ResponseDTO.userErrorParam((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        EmployeeEntity employeeEntity_l = this.employeeService.getByLoginPhone(phone);
        if (null != employeeEntity_l) {
            if (employeeEntity_l.getBlockingTime().compareTo(LocalDateTime.now()) < 0) {
                return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u8fc7\u671f,\u8bf7\u7eed\u8d39\u4e4b\u540e\u4f7f\u7528\uff01");
            }
        } else if (null == employeeEntity_l) {
            if (this.employeeService.getById(Long.valueOf(2L)) != null) {
                return ResponseDTO.userErrorParam((String)"\u8be5\u8bbe\u5907\u5df2\u6ce8\u518c\u8d26\u53f7\uff0c\u6bcf\u53f0\u8bbe\u5907\u4ec5\u53ef\u767b\u5f55\u4e00\u4e2a\u8d26\u53f7\uff0c\u8bf7\u6362\u8bbe\u5907\u540e\u767b\u5f55\uff01");
            }
            ResponseDTO publicUserInfo = PublicLogin.queryPublicUserInfo((String)phone, null);
            System.out.println(publicUserInfo);
            if (!publicUserInfo.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)publicUserInfo.getMsg());
            }
            PublicUserInfo publicUserInfoEntity = (PublicUserInfo)publicUserInfo.getData();
            String userStatus = String.valueOf(publicUserInfoEntity.getUserStatus());
            if (userStatus.equals("1")) {
                return ResponseDTO.userErrorParam((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u7981\u7528,\u8bf7\u8054\u7cfb\u5de5\u4f5c\u4eba\u5458\uff01");
            }
            String bindStatus = String.valueOf(publicUserInfoEntity.getBindStatus());
            if (bindStatus.equals("1")) {
                return ResponseDTO.userErrorParam((String)"\u8be5\u8d26\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u8bbe\u5907");
            }
            EmployeeAddForm employeeAddForm = new EmployeeAddForm();
            employeeAddForm.setActualName(publicUserInfoEntity.getUserName());
            employeeAddForm.setDepartmentId(Long.valueOf(5L));
            employeeAddForm.setDisabledFlag(Boolean.FALSE);
            employeeAddForm.setGender(Integer.valueOf(1));
            employeeAddForm.setLoginName(publicUserInfoEntity.getLoginName());
            employeeAddForm.setPhone(publicUserInfoEntity.getLoginPhone());
            ArrayList<Long> roleIdList = new ArrayList<Long>();
            roleIdList.add(58L);
            employeeAddForm.setRoleIdList(roleIdList);
            employeeAddForm.setBlockingTime(publicUserInfoEntity.getBlockingTime());
            employeeAddForm.setPayUser(Boolean.TRUE.booleanValue());
            ResponseDTO stringResponseDTO = this.employeeService.addEmployeeByPassword(employeeAddForm, publicUserInfoEntity.getLoginPassword());
            if (!stringResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)stringResponseDTO.getMsg());
            }
            ResponseDTO infoResponseDTO = PublicLogin.UpdatePublicUserInfo((String)phone, null);
            if (!infoResponseDTO.getOk().booleanValue()) {
                return ResponseDTO.userErrorParam((String)infoResponseDTO.getMsg());
            }
            this.redisTemplate.delete((Object)("PHONE_" + phone));
        }
        EmployeeEntity employeeEntity = this.employeeService.getByLoginPhone(phone);
        String saTokenLoginId = UserTypeEnum.ADMIN_EMPLOYEE.getValue() + ":" + employeeEntity.getEmployeeId();
        StpUtil.login((Object)saTokenLoginId, (String)String.valueOf(loginDeviceEnum.getDesc()));
        RequestEmployee requestEmployee = this.loadLoginInfo(employeeEntity);
        this.loginEmployeeCache.put(employeeEntity.getEmployeeId(), requestEmployee);
        this.protectLoginService.removeLoginFail(employeeEntity.getEmployeeId(), UserTypeEnum.ADMIN_EMPLOYEE);
        LoginResultVO loginResultVO = this.getLoginResult(requestEmployee);
        this.updateLoginFirstInfo(employeeEntity.getEmployeeId(), true);
        loginResultVO.setToken(StpUtil.getTokenValue());
        this.permissionCache.remove(employeeEntity.getEmployeeId());
        return ResponseDTO.ok((Object)loginResultVO);
    }

    public ResponseDTO<LoginResultVO> getVerificationCode(LoginForm loginForm) {
        Object loginResultVO = null;
        String phone = loginForm.getPhoneNumber();
        String smsCode = LoginService.generateSmsCode();
        Config config = new Config().setAccessKeyId("LTAI5tFTymAnGsG3HDHrZU4V").setAccessKeySecret("7jiLfyENZDebiDiWJJNjiKRVWFWati");
        config.endpoint = "dysmsapi.aliyuncs.com";
        Client client = null;
        try {
            client = new Client(config);
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName("\u5317\u4eac\u8fc8\u8fea\u751f\u79d1\u6280").setTemplateCode("\nSMS_486465224").setPhoneNumbers(phone).setTemplateParam("{\"code\":" + smsCode + "}");
            client.sendSms(sendSmsRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.redisTemplate.opsForValue().set((Object)("PHONE_" + phone), (Object)smsCode, 300L, TimeUnit.SECONDS);
        return ResponseDTO.ok(loginResultVO);
    }

    public ResponseDTO<LoginResultVO> getVerificationCodeForRegister(RegisterForm registerForm) {
        Object loginResultVO = null;
        String phone = registerForm.getLoginPhone();
        String smsCode = LoginService.generateSmsCode();
        Config config = new Config().setAccessKeyId("LTAI5tFTymAnGsG3HDHrZU4V").setAccessKeySecret("7jiLfyENZDebiDiWJJNjiKRVWFWati");
        config.endpoint = "dysmsapi.aliyuncs.com";
        Client client = null;
        try {
            client = new Client(config);
            SendSmsRequest sendSmsRequest = new SendSmsRequest().setSignName("\u5317\u4eac\u8fc8\u8fea\u751f\u79d1\u6280").setTemplateCode("\nSMS_486435239").setPhoneNumbers(phone).setTemplateParam("{\"code\":" + smsCode + "}");
            client.sendSms(sendSmsRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.redisTemplate.opsForValue().set((Object)("PHONE_" + phone), (Object)smsCode, 300L, TimeUnit.SECONDS);
        return ResponseDTO.ok(loginResultVO);
    }

    public static String generateSmsCode() {
        Random random = new Random();
        int code = random.nextInt(900000) + 100000;
        return String.format("%06d", code);
    }

    public ResponseDTO<LoginResultVO> registerForPublic(RegisterForm registerForm) {
        String code = registerForm.getVerificationCode();
        String phone = registerForm.getLoginPhone();
        String loginKey = registerForm.getLoginKey();
        String rightCode = (String)this.redisTemplate.opsForValue().get((Object)("PHONE_" + phone));
        if (!code.equals(rightCode)) {
            return ResponseDTO.userErrorParam((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        ResponseDTO keyInfo = PublicLogin.queryPublicKeyInfo((String)loginKey, (String)phone);
        if (!keyInfo.getOk().booleanValue()) {
            return ResponseDTO.userErrorParam((String)keyInfo.getMsg());
        }
        PublicUserInfo publicUserInfo = new PublicUserInfo();
        publicUserInfo.setLoginName(registerForm.getLoginName());
        publicUserInfo.setUserName(registerForm.getLoginName());
        publicUserInfo.setLoginPhone(phone);
        publicUserInfo.setLoginPassword(registerForm.getPassword());
        publicUserInfo.setCreateTime(LocalDateTime.now());
        publicUserInfo.setActiveTime(((KeyInfo)keyInfo.getData()).getKeyTime());
        publicUserInfo.setBlockingTime(LocalDateTime.now().plusMonths(Long.parseLong(((KeyInfo)keyInfo.getData()).getKeyTime())));
        publicUserInfo.setUserStatus(0);
        publicUserInfo.setBindStatus(0);
        ResponseDTO responseDTO = PublicLogin.RegisterPublicUser((PublicUserInfo)publicUserInfo);
        if (!responseDTO.getOk().booleanValue()) {
            return ResponseDTO.userErrorParam((String)responseDTO.getMsg());
        }
        ResponseDTO keyUpdataInfo = PublicLogin.UpdatePublicKeyInfo((String)loginKey);
        if (!keyUpdataInfo.getOk().booleanValue()) {
            return ResponseDTO.userErrorParam((String)keyInfo.getMsg());
        }
        this.redisTemplate.delete((Object)("PHONE_" + phone));
        return ResponseDTO.ok();
    }
}

