/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.menu.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuAddForm;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuUpdateForm;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuTreeVO;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuVO;
import net.lab1024.sa.admin.module.system.menu.service.MenuService;
import net.lab1024.sa.base.common.domain.RequestUrlVO;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u83dc\u5355")
public class MenuController {
    @Resource
    private MenuService menuService;

    @Operation(summary="\u6dfb\u52a0\u83dc\u5355 @author \u5353\u5927")
    @PostMapping(value={"/menu/add"})
    @SaCheckPermission(value={"system:menu:add"})
    public ResponseDTO<String> addMenu(@RequestBody @Valid MenuAddForm menuAddForm) {
        menuAddForm.setCreateUserId(SmartRequestUtil.getRequestUserId());
        return this.menuService.addMenu(menuAddForm);
    }

    @Operation(summary="\u66f4\u65b0\u83dc\u5355 @author \u5353\u5927")
    @PostMapping(value={"/menu/update"})
    @SaCheckPermission(value={"system:menu:update"})
    public ResponseDTO<String> updateMenu(@RequestBody @Valid MenuUpdateForm menuUpdateForm) {
        menuUpdateForm.setUpdateUserId(SmartRequestUtil.getRequestUserId());
        return this.menuService.updateMenu(menuUpdateForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u83dc\u5355 @author \u5353\u5927")
    @GetMapping(value={"/menu/batchDelete"})
    @SaCheckPermission(value={"system:menu:batchDelete"})
    public ResponseDTO<String> batchDeleteMenu(@RequestParam(value="menuIdList") List<Long> menuIdList) {
        return this.menuService.batchDeleteMenu(menuIdList, SmartRequestUtil.getRequestUserId());
    }

    @Operation(summary="\u67e5\u8be2\u83dc\u5355\u5217\u8868 @author \u5353\u5927")
    @GetMapping(value={"/menu/query"})
    public ResponseDTO<List<MenuVO>> queryMenuList() {
        return ResponseDTO.ok((Object)this.menuService.queryMenuList(null));
    }

    @Operation(summary="\u67e5\u8be2\u83dc\u5355\u8be6\u60c5 @author \u5353\u5927")
    @GetMapping(value={"/menu/detail/{menuId}"})
    public ResponseDTO<MenuVO> getMenuDetail(@PathVariable Long menuId) {
        return this.menuService.getMenuDetail(menuId);
    }

    @Operation(summary="\u67e5\u8be2\u83dc\u5355\u6811 @author \u5353\u5927")
    @GetMapping(value={"/menu/tree"})
    public ResponseDTO<List<MenuTreeVO>> queryMenuTree(@RequestParam(value="onlyMenu") Boolean onlyMenu) {
        return this.menuService.queryMenuTree(onlyMenu);
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u8bf7\u6c42\u8def\u5f84 @author \u5353\u5927")
    @GetMapping(value={"/menu/auth/url"})
    public ResponseDTO<List<RequestUrlVO>> getAuthUrl() {
        return this.menuService.getAuthUrl();
    }
}

