/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.menu.service;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.menu.constant.MenuTypeEnum;
import net.lab1024.sa.admin.module.system.menu.dao.MenuDao;
import net.lab1024.sa.admin.module.system.menu.domain.entity.MenuEntity;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuAddForm;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuBaseForm;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuUpdateForm;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuTreeVO;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuVO;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.SystemErrorCode;
import net.lab1024.sa.base.common.domain.RequestUrlVO;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MenuService {
    @Resource
    private MenuDao menuDao;
    @Resource
    private List<RequestUrlVO> authUrl;

    public synchronized ResponseDTO<String> addMenu(MenuAddForm menuAddForm) {
        if (this.validateMenuName((MenuBaseForm)menuAddForm).booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.validateWebPerms((MenuBaseForm)menuAddForm).booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u524d\u7aef\u6743\u9650\u5b57\u7b26\u4e32\u5df2\u5b58\u5728");
        }
        MenuEntity menuEntity = (MenuEntity)SmartBeanUtil.copy((Object)menuAddForm, MenuEntity.class);
        this.menuDao.insert((Object)menuEntity);
        return ResponseDTO.ok();
    }

    public synchronized ResponseDTO<String> updateMenu(MenuUpdateForm menuUpdateForm) {
        MenuEntity selectMenu = (MenuEntity)this.menuDao.selectById((Serializable)menuUpdateForm.getMenuId());
        if (selectMenu == null) {
            return ResponseDTO.userErrorParam((String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        if (selectMenu.getDeletedFlag().booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u83dc\u5355\u5df2\u88ab\u5220\u9664");
        }
        if (this.validateMenuName((MenuBaseForm)menuUpdateForm).booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.validateWebPerms((MenuBaseForm)menuUpdateForm).booleanValue()) {
            return ResponseDTO.userErrorParam((String)"\u524d\u7aef\u6743\u9650\u5b57\u7b26\u4e32\u5df2\u5b58\u5728");
        }
        if (menuUpdateForm.getMenuId().equals(menuUpdateForm.getParentId())) {
            return ResponseDTO.userErrorParam((String)"\u4e0a\u7ea7\u83dc\u5355\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        MenuEntity menuEntity = (MenuEntity)SmartBeanUtil.copy((Object)menuUpdateForm, MenuEntity.class);
        this.menuDao.updateById((Object)menuEntity);
        return ResponseDTO.ok();
    }

    public synchronized ResponseDTO<String> batchDeleteMenu(List<Long> menuIdList, Long employeeId) {
        if (CollectionUtils.isEmpty(menuIdList)) {
            return ResponseDTO.userErrorParam((String)"\u6240\u9009\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.menuDao.deleteByMenuIdList(menuIdList, employeeId, Boolean.TRUE);
        this.recursiveDeleteChildren(menuIdList, employeeId);
        return ResponseDTO.ok();
    }

    private void recursiveDeleteChildren(List<Long> menuIdList, Long employeeId) {
        List childrenMenuIdList = this.menuDao.selectMenuIdByParentIdList(menuIdList);
        if (CollectionUtil.isEmpty((Collection)childrenMenuIdList)) {
            return;
        }
        this.menuDao.deleteByMenuIdList(childrenMenuIdList, employeeId, Boolean.TRUE);
        this.recursiveDeleteChildren(childrenMenuIdList, employeeId);
    }

    public <T extends MenuBaseForm> Boolean validateMenuName(T menuDTO) {
        MenuEntity menu = this.menuDao.getByMenuName(menuDTO.getMenuName(), menuDTO.getParentId(), Boolean.FALSE);
        if (menuDTO instanceof MenuAddForm) {
            return menu != null;
        }
        if (menuDTO instanceof MenuUpdateForm) {
            Long menuId = ((MenuUpdateForm)menuDTO).getMenuId();
            return menu != null && menu.getMenuId().longValue() != menuId.longValue();
        }
        return true;
    }

    public <T extends MenuBaseForm> Boolean validateWebPerms(T menuDTO) {
        MenuEntity menu = this.menuDao.getByWebPerms(menuDTO.getWebPerms(), Boolean.FALSE);
        if (menuDTO instanceof MenuAddForm) {
            return menu != null;
        }
        if (menuDTO instanceof MenuUpdateForm) {
            Long menuId = ((MenuUpdateForm)menuDTO).getMenuId();
            return menu != null && menu.getMenuId().longValue() != menuId.longValue();
        }
        return true;
    }

    public List<MenuVO> queryMenuList(Boolean disabledFlag) {
        List menuVOList = this.menuDao.queryMenuList(Boolean.FALSE, disabledFlag, null);
        Map parentMap = menuVOList.stream().collect(Collectors.groupingBy(MenuBaseForm::getParentId, Collectors.toList()));
        return this.filterNoParentMenu(parentMap, NumberUtils.LONG_ZERO);
    }

    private List<MenuVO> filterNoParentMenu(Map<Long, List<MenuVO>> parentMap, Long parentId) {
        List<MenuVO> res = parentMap.getOrDefault(parentId, Lists.newArrayList());
        ArrayList childMenu = Lists.newArrayList();
        res.forEach(e -> {
            List menuList = this.filterNoParentMenu(parentMap, e.getMenuId());
            childMenu.addAll(menuList);
        });
        res.addAll(childMenu);
        return res;
    }

    public ResponseDTO<List<MenuTreeVO>> queryMenuTree(Boolean onlyMenu) {
        ArrayList menuTypeList = Lists.newArrayList();
        if (onlyMenu.booleanValue()) {
            menuTypeList = Lists.newArrayList((Object[])new Integer[]{MenuTypeEnum.CATALOG.getValue(), MenuTypeEnum.MENU.getValue()});
        }
        List menuVOList = this.menuDao.queryMenuList(Boolean.FALSE, null, (List)menuTypeList);
        Map parentMap = menuVOList.stream().collect(Collectors.groupingBy(MenuBaseForm::getParentId, Collectors.toList()));
        List menuTreeVOList = this.buildMenuTree(parentMap, NumberUtils.LONG_ZERO);
        return ResponseDTO.ok((Object)menuTreeVOList);
    }

    List<MenuTreeVO> buildMenuTree(Map<Long, List<MenuVO>> parentMap, Long parentId) {
        List<MenuTreeVO> res = parentMap.getOrDefault(parentId, Lists.newArrayList()).stream().map(e -> (MenuTreeVO)SmartBeanUtil.copy((Object)e, MenuTreeVO.class)).collect(Collectors.toList());
        res.forEach(e -> e.setChildren(this.buildMenuTree(parentMap, e.getMenuId())));
        return res;
    }

    public ResponseDTO<MenuVO> getMenuDetail(Long menuId) {
        MenuEntity selectMenu = (MenuEntity)this.menuDao.selectById((Serializable)menuId);
        if (selectMenu == null) {
            return ResponseDTO.error((ErrorCode)SystemErrorCode.SYSTEM_ERROR, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        }
        if (selectMenu.getDeletedFlag().booleanValue()) {
            return ResponseDTO.error((ErrorCode)SystemErrorCode.SYSTEM_ERROR, (String)"\u83dc\u5355\u5df2\u88ab\u5220\u9664");
        }
        MenuVO menuVO = (MenuVO)SmartBeanUtil.copy((Object)selectMenu, MenuVO.class);
        return ResponseDTO.ok((Object)menuVO);
    }

    public ResponseDTO<List<RequestUrlVO>> getAuthUrl() {
        return ResponseDTO.ok((Object)this.authUrl);
    }
}

