/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.position.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.position.domain.form.PositionAddForm;
import net.lab1024.sa.admin.module.system.position.domain.form.PositionQueryForm;
import net.lab1024.sa.admin.module.system.position.domain.form.PositionUpdateForm;
import net.lab1024.sa.admin.module.system.position.domain.vo.PositionVO;
import net.lab1024.sa.admin.module.system.position.service.PositionService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u804c\u52a1\u7ba1\u7406")
public class PositionController {
    @Resource
    private PositionService positionService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author kaiyun")
    @PostMapping(value={"/position/queryPage"})
    public ResponseDTO<PageResult<PositionVO>> queryPage(@RequestBody @Valid PositionQueryForm queryForm) {
        return ResponseDTO.ok((Object)this.positionService.queryPage(queryForm));
    }

    @Operation(summary="\u6dfb\u52a0 @author kaiyun")
    @PostMapping(value={"/position/add"})
    public ResponseDTO<String> add(@RequestBody @Valid PositionAddForm addForm) {
        return this.positionService.add(addForm);
    }

    @Operation(summary="\u66f4\u65b0 @author kaiyun")
    @PostMapping(value={"/position/update"})
    public ResponseDTO<String> update(@RequestBody @Valid PositionUpdateForm updateForm) {
        return this.positionService.update(updateForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author kaiyun")
    @PostMapping(value={"/position/batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody ValidateList<Long> idList) {
        return this.positionService.batchDelete(idList);
    }

    @Operation(summary="\u5355\u4e2a\u5220\u9664 @author kaiyun")
    @GetMapping(value={"/position/delete/{positionId}"})
    public ResponseDTO<String> batchDelete(@PathVariable Long positionId) {
        return this.positionService.delete(positionId);
    }

    @Operation(summary="\u4e0d\u5206\u9875\u67e5\u8be2 @author kaiyun")
    @GetMapping(value={"/position/queryList"})
    public ResponseDTO<List<PositionVO>> queryList() {
        return ResponseDTO.ok((Object)this.positionService.queryList());
    }
}

