/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleAddForm;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleVO;
import net.lab1024.sa.admin.module.system.role.service.RoleService;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u89d2\u8272")
public class RoleController {
    @Resource
    private RoleService roleService;

    @Operation(summary="\u6dfb\u52a0\u89d2\u8272 @author \u5353\u5927")
    @PostMapping(value={"/role/add"})
    @SaCheckPermission(value={"system:role:add"})
    public ResponseDTO<String> addRole(@Valid @RequestBody RoleAddForm roleAddForm) {
        return this.roleService.addRole(roleAddForm);
    }

    @Operation(summary="\u5220\u9664\u89d2\u8272 @author \u5353\u5927")
    @GetMapping(value={"/role/delete/{roleId}"})
    @SaCheckPermission(value={"system:role:delete"})
    public ResponseDTO<String> deleteRole(@PathVariable Long roleId) {
        return this.roleService.deleteRole(roleId);
    }

    @Operation(summary="\u66f4\u65b0\u89d2\u8272 @author \u5353\u5927")
    @PostMapping(value={"/role/update"})
    @SaCheckPermission(value={"system:role:update"})
    public ResponseDTO<String> updateRole(@Valid @RequestBody RoleUpdateForm roleUpdateDTO) {
        return this.roleService.updateRole(roleUpdateDTO);
    }

    @Operation(summary="\u83b7\u53d6\u89d2\u8272\u6570\u636e @author \u5353\u5927")
    @GetMapping(value={"/role/get/{roleId}"})
    public ResponseDTO<RoleVO> getRole(@PathVariable(value="roleId") Long roleId) {
        return this.roleService.getRoleById(roleId);
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u89d2\u8272 @author \u5353\u5927")
    @GetMapping(value={"/role/getAll"})
    public ResponseDTO<List<RoleVO>> getAllRole() {
        return this.roleService.getAllRole();
    }
}

