/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.admin.module.system.employee.domain.vo.EmployeeVO;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleEmployeeQueryForm;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleEmployeeUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleSelectedVO;
import net.lab1024.sa.admin.module.system.role.service.RoleEmployeeService;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u7cfb\u7edf-\u89d2\u8272-\u5458\u5de5")
public class RoleEmployeeController {
    @Resource
    private RoleEmployeeService roleEmployeeService;

    @Operation(summary="\u67e5\u8be2\u67d0\u4e2a\u89d2\u8272\u4e0b\u7684\u5458\u5de5\u5217\u8868  @author \u5353\u5927")
    @PostMapping(value={"/role/employee/queryEmployee"})
    public ResponseDTO<PageResult<EmployeeVO>> queryEmployee(@Valid @RequestBody RoleEmployeeQueryForm roleEmployeeQueryForm) {
        return this.roleEmployeeService.queryEmployee(roleEmployeeQueryForm);
    }

    @Operation(summary="\u83b7\u53d6\u67d0\u4e2a\u89d2\u8272\u4e0b\u7684\u6240\u6709\u5458\u5de5\u5217\u8868(\u65e0\u5206\u9875)  @author \u5353\u5927")
    @GetMapping(value={"/role/employee/getAllEmployeeByRoleId/{roleId}"})
    public ResponseDTO<List<EmployeeVO>> listAllEmployeeRoleId(@PathVariable Long roleId) {
        return ResponseDTO.ok((Object)this.roleEmployeeService.getAllEmployeeByRoleId(roleId));
    }

    @Operation(summary="\u4ece\u89d2\u8272\u6210\u5458\u5217\u8868\u4e2d\u79fb\u9664\u5458\u5de5 @author \u5353\u5927")
    @GetMapping(value={"/role/employee/removeEmployee"})
    @SaCheckPermission(value={"system:role:employee:delete"})
    public ResponseDTO<String> removeEmployee(Long employeeId, Long roleId) {
        return this.roleEmployeeService.removeRoleEmployee(employeeId, roleId);
    }

    @Operation(summary="\u4ece\u89d2\u8272\u6210\u5458\u5217\u8868\u4e2d\u6279\u91cf\u79fb\u9664\u5458\u5de5 @author \u5353\u5927")
    @PostMapping(value={"/role/employee/batchRemoveRoleEmployee"})
    @SaCheckPermission(value={"system:role:employee:batch:delete"})
    public ResponseDTO<String> batchRemoveEmployee(@Valid @RequestBody RoleEmployeeUpdateForm updateForm) {
        return this.roleEmployeeService.batchRemoveRoleEmployee(updateForm);
    }

    @Operation(summary="\u89d2\u8272\u6210\u5458\u5217\u8868\u4e2d\u6279\u91cf\u6dfb\u52a0\u5458\u5de5 @author \u5353\u5927")
    @PostMapping(value={"/role/employee/batchAddRoleEmployee"})
    @SaCheckPermission(value={"system:role:employee:add"})
    public ResponseDTO<String> addEmployeeList(@Valid @RequestBody RoleEmployeeUpdateForm addForm) {
        return this.roleEmployeeService.batchAddRoleEmployee(addForm);
    }

    @Operation(summary="\u83b7\u53d6\u5458\u5de5\u6240\u6709\u9009\u4e2d\u7684\u89d2\u8272\u548c\u6240\u6709\u89d2\u8272 @author \u5353\u5927")
    @GetMapping(value={"/role/employee/getRoles/{employeeId}"})
    public ResponseDTO<List<RoleSelectedVO>> getRoleByEmployeeId(@PathVariable Long employeeId) {
        return ResponseDTO.ok((Object)this.roleEmployeeService.getRoleInfoListByEmployeeId(employeeId));
    }
}

