/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.service;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.role.dao.RoleDataScopeDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleDataScopeEntity;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleDataScopeUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleDataScopeVO;
import net.lab1024.sa.admin.module.system.role.manager.RoleDataScopeManager;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RoleDataScopeService {
    @Resource
    private RoleDataScopeManager roleDataScopeManager;

    public ResponseDTO<List<RoleDataScopeVO>> getRoleDataScopeList(Long roleId) {
        List roleDataScopeEntityList = ((RoleDataScopeDao)this.roleDataScopeManager.getBaseMapper()).listByRoleId(roleId);
        if (CollectionUtils.isEmpty((Collection)roleDataScopeEntityList)) {
            return ResponseDTO.ok((Object)Lists.newArrayList());
        }
        List roleDataScopeList = SmartBeanUtil.copyList((List)roleDataScopeEntityList, RoleDataScopeVO.class);
        return ResponseDTO.ok((Object)roleDataScopeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> updateRoleDataScopeList(RoleDataScopeUpdateForm roleDataScopeUpdateForm) {
        List batchSetList = roleDataScopeUpdateForm.getDataScopeItemList();
        if (CollectionUtils.isEmpty((Collection)batchSetList)) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.PARAM_ERROR, (String)"\u7f3a\u5c11\u914d\u7f6e\u4fe1\u606f");
        }
        List roleDataScopeEntityList = SmartBeanUtil.copyList((List)batchSetList, RoleDataScopeEntity.class);
        roleDataScopeEntityList.forEach(e -> e.setRoleId(roleDataScopeUpdateForm.getRoleId()));
        ((RoleDataScopeDao)this.roleDataScopeManager.getBaseMapper()).deleteByRoleId(roleDataScopeUpdateForm.getRoleId());
        this.roleDataScopeManager.saveBatch((Collection)roleDataScopeEntityList);
        return ResponseDTO.ok();
    }
}

