/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.department.dao.DepartmentDao;
import net.lab1024.sa.admin.module.system.department.domain.entity.DepartmentEntity;
import net.lab1024.sa.admin.module.system.employee.domain.vo.EmployeeVO;
import net.lab1024.sa.admin.module.system.role.dao.RoleDao;
import net.lab1024.sa.admin.module.system.role.dao.RoleEmployeeDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleEmployeeEntity;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleEmployeeQueryForm;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleEmployeeUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleSelectedVO;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleVO;
import net.lab1024.sa.admin.module.system.role.manager.RoleEmployeeManager;
import net.lab1024.sa.base.common.domain.PageParam;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import net.lab1024.sa.base.common.util.SmartPageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleEmployeeService {
    @Resource
    private RoleEmployeeDao roleEmployeeDao;
    @Resource
    private RoleDao roleDao;
    @Resource
    private DepartmentDao departmentDao;
    @Resource
    private RoleEmployeeManager roleEmployeeManager;

    public void batchInsert(List<RoleEmployeeEntity> roleEmployeeList) {
        this.roleEmployeeManager.saveBatch(roleEmployeeList);
    }

    public ResponseDTO<PageResult<EmployeeVO>> queryEmployee(RoleEmployeeQueryForm roleEmployeeQueryForm) {
        Page page = SmartPageUtil.convert2PageQuery((PageParam)roleEmployeeQueryForm);
        List<EmployeeVO> employeeList = this.roleEmployeeDao.selectRoleEmployeeByName(page, roleEmployeeQueryForm).stream().filter(Objects::nonNull).collect(Collectors.toList());
        List departmentIdList = employeeList.stream().filter(e -> e != null && e.getDepartmentId() != null).map(EmployeeVO::getDepartmentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(departmentIdList)) {
            List departmentEntities = this.departmentDao.selectBatchIds(departmentIdList);
            Map<Long, String> departmentIdNameMap = departmentEntities.stream().collect(Collectors.toMap(DepartmentEntity::getDepartmentId, DepartmentEntity::getName));
            employeeList.forEach(e -> e.setDepartmentName(departmentIdNameMap.getOrDefault(e.getDepartmentId(), "")));
        }
        PageResult pageResult = SmartPageUtil.convert2PageResult((Page)page, employeeList, EmployeeVO.class);
        return ResponseDTO.ok((Object)pageResult);
    }

    public List<EmployeeVO> getAllEmployeeByRoleId(Long roleId) {
        return this.roleEmployeeDao.selectEmployeeByRoleId(roleId);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> removeRoleEmployee(Long employeeId, Long roleId) {
        if (null == employeeId || null == roleId) {
            return ResponseDTO.userErrorParam();
        }
        this.roleEmployeeDao.deleteByEmployeeIdRoleId(employeeId, roleId);
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchRemoveRoleEmployee(RoleEmployeeUpdateForm roleEmployeeUpdateForm) {
        this.roleEmployeeDao.batchDeleteEmployeeRole(roleEmployeeUpdateForm.getRoleId(), roleEmployeeUpdateForm.getEmployeeIdList());
        return ResponseDTO.ok();
    }

    public ResponseDTO<String> batchAddRoleEmployee(RoleEmployeeUpdateForm roleEmployeeUpdateForm) {
        Long roleId = roleEmployeeUpdateForm.getRoleId();
        List employeeIdList = roleEmployeeUpdateForm.getEmployeeIdList();
        List roleEmployeeList = null;
        if (CollectionUtils.isNotEmpty((Collection)employeeIdList)) {
            roleEmployeeList = employeeIdList.stream().map(employeeId -> new RoleEmployeeEntity(roleId, employeeId)).collect(Collectors.toList());
        }
        this.roleEmployeeManager.saveRoleEmployee(roleId, roleEmployeeList);
        return ResponseDTO.ok();
    }

    public List<RoleSelectedVO> getRoleInfoListByEmployeeId(Long employeeId) {
        List roleIds = this.roleEmployeeDao.selectRoleIdByEmployeeId(employeeId);
        List roleList = this.roleDao.selectList(null);
        List result = SmartBeanUtil.copyList((List)roleList, RoleSelectedVO.class);
        result.stream().forEach(item -> item.setSelected(Boolean.valueOf(roleIds.contains(item.getRoleId()))));
        return result;
    }

    public List<RoleVO> getRoleIdList(Long employeeId) {
        return this.roleEmployeeDao.selectRoleByEmployeeId(employeeId);
    }
}

