/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.service;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.menu.dao.MenuDao;
import net.lab1024.sa.admin.module.system.menu.domain.form.MenuBaseForm;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuSimpleTreeVO;
import net.lab1024.sa.admin.module.system.menu.domain.vo.MenuVO;
import net.lab1024.sa.admin.module.system.role.dao.RoleDao;
import net.lab1024.sa.admin.module.system.role.dao.RoleMenuDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleEntity;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleMenuEntity;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleMenuUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleMenuTreeVO;
import net.lab1024.sa.admin.module.system.role.manager.RoleMenuManager;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Service;

@Service
public class RoleMenuService {
    @Resource
    private RoleDao roleDao;
    @Resource
    private RoleMenuDao roleMenuDao;
    @Resource
    private RoleMenuManager roleMenuManager;
    @Resource
    private MenuDao menuDao;

    public ResponseDTO<String> updateRoleMenu(RoleMenuUpdateForm roleMenuUpdateForm) {
        Long roleId = roleMenuUpdateForm.getRoleId();
        RoleEntity roleEntity = (RoleEntity)this.roleDao.selectById((Serializable)roleId);
        if (null == roleEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        ArrayList roleMenuEntityList = Lists.newArrayList();
        for (Long menuId : roleMenuUpdateForm.getMenuIdList()) {
            RoleMenuEntity roleMenuEntity = new RoleMenuEntity();
            roleMenuEntity.setRoleId(roleId);
            roleMenuEntity.setMenuId(menuId);
            roleMenuEntityList.add(roleMenuEntity);
        }
        this.roleMenuManager.updateRoleMenu(roleMenuUpdateForm.getRoleId(), (List)roleMenuEntityList);
        return ResponseDTO.ok();
    }

    public List<MenuVO> getMenuList(List<Long> roleIdList, Boolean administratorFlag) {
        if (administratorFlag.booleanValue()) {
            List menuEntityList = this.roleMenuDao.selectMenuListByRoleIdList((List)Lists.newArrayList(), Boolean.valueOf(false));
            return SmartBeanUtil.copyList((List)menuEntityList, MenuVO.class);
        }
        if (CollectionUtils.isEmpty(roleIdList)) {
            return new ArrayList<MenuVO>();
        }
        List menuEntityList = this.roleMenuDao.selectMenuListByRoleIdList(roleIdList, Boolean.valueOf(false));
        return SmartBeanUtil.copyList((List)menuEntityList, MenuVO.class);
    }

    public ResponseDTO<RoleMenuTreeVO> getRoleSelectedMenu(Long roleId) {
        RoleMenuTreeVO res = new RoleMenuTreeVO();
        res.setRoleId(roleId);
        List selectedMenuId = this.roleMenuDao.queryMenuIdByRoleId(roleId);
        res.setSelectedMenuId(selectedMenuId);
        List menuVOList = this.menuDao.queryMenuList(Boolean.FALSE, Boolean.FALSE, null);
        Map parentMap = menuVOList.stream().collect(Collectors.groupingBy(MenuBaseForm::getParentId, Collectors.toList()));
        List menuTreeList = this.buildMenuTree(parentMap, NumberUtils.LONG_ZERO);
        res.setMenuTreeList(menuTreeList);
        return ResponseDTO.ok((Object)res);
    }

    private List<MenuSimpleTreeVO> buildMenuTree(Map<Long, List<MenuVO>> parentMap, Long parentId) {
        List<MenuSimpleTreeVO> res = parentMap.getOrDefault(parentId, Lists.newArrayList()).stream().map(e -> (MenuSimpleTreeVO)SmartBeanUtil.copy((Object)e, MenuSimpleTreeVO.class)).collect(Collectors.toList());
        res.forEach(e -> e.setChildren(this.buildMenuTree(parentMap, e.getMenuId())));
        return res;
    }
}

