/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.role.service;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import net.lab1024.sa.admin.module.system.role.dao.RoleDao;
import net.lab1024.sa.admin.module.system.role.dao.RoleEmployeeDao;
import net.lab1024.sa.admin.module.system.role.dao.RoleMenuDao;
import net.lab1024.sa.admin.module.system.role.domain.entity.RoleEntity;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleAddForm;
import net.lab1024.sa.admin.module.system.role.domain.form.RoleUpdateForm;
import net.lab1024.sa.admin.module.system.role.domain.vo.RoleVO;
import net.lab1024.sa.base.common.code.ErrorCode;
import net.lab1024.sa.base.common.code.UserErrorCode;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartBeanUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleService {
    @Resource
    private RoleDao roleDao;
    @Resource
    private RoleMenuDao roleMenuDao;
    @Resource
    private RoleEmployeeDao roleEmployeeDao;

    public ResponseDTO<String> addRole(RoleAddForm roleAddForm) {
        RoleEntity existRoleEntity = this.roleDao.getByRoleName(roleAddForm.getRoleName());
        if (null != existRoleEntity) {
            return ResponseDTO.userErrorParam((String)"\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        existRoleEntity = this.roleDao.getByRoleCode(roleAddForm.getRoleCode());
        if (null != existRoleEntity) {
            return ResponseDTO.userErrorParam((String)("\u89d2\u8272\u7f16\u7801\u91cd\u590d\uff0c\u91cd\u590d\u7684\u89d2\u8272\u4e3a\uff1a" + existRoleEntity.getRoleName()));
        }
        RoleEntity roleEntity = (RoleEntity)SmartBeanUtil.copy((Object)roleAddForm, RoleEntity.class);
        this.roleDao.insert((Object)roleEntity);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> deleteRole(Long roleId) {
        RoleEntity roleEntity = (RoleEntity)this.roleDao.selectById((Serializable)roleId);
        if (null == roleEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        this.roleDao.deleteById((Serializable)roleId);
        this.roleMenuDao.deleteByRoleId(roleId);
        this.roleEmployeeDao.deleteByRoleId(roleId);
        return ResponseDTO.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseDTO<String> updateRole(RoleUpdateForm roleUpdateForm) {
        if (null == this.roleDao.selectById((Serializable)roleUpdateForm.getRoleId())) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        RoleEntity existRoleEntity = this.roleDao.getByRoleName(roleUpdateForm.getRoleName());
        if (null != existRoleEntity && !existRoleEntity.getRoleId().equals(roleUpdateForm.getRoleId())) {
            return ResponseDTO.userErrorParam((String)"\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        existRoleEntity = this.roleDao.getByRoleCode(roleUpdateForm.getRoleCode());
        if (null != existRoleEntity) {
            return ResponseDTO.userErrorParam((String)("\u89d2\u8272\u7f16\u7801\u91cd\u590d\uff0c\u91cd\u590d\u7684\u89d2\u8272\u4e3a\uff1a" + existRoleEntity.getRoleName()));
        }
        RoleEntity roleEntity = (RoleEntity)SmartBeanUtil.copy((Object)roleUpdateForm, RoleEntity.class);
        this.roleDao.updateById((Object)roleEntity);
        return ResponseDTO.ok();
    }

    public ResponseDTO<RoleVO> getRoleById(Long roleId) {
        RoleEntity roleEntity = (RoleEntity)this.roleDao.selectById((Serializable)roleId);
        if (null == roleEntity) {
            return ResponseDTO.error((ErrorCode)UserErrorCode.DATA_NOT_EXIST);
        }
        RoleVO role = (RoleVO)SmartBeanUtil.copy((Object)roleEntity, RoleVO.class);
        return ResponseDTO.ok((Object)role);
    }

    public ResponseDTO<List<RoleVO>> getAllRole() {
        List roleEntityList = this.roleDao.selectList(null);
        List roleList = SmartBeanUtil.copyList((List)roleEntityList, RoleVO.class);
        return ResponseDTO.ok((Object)roleList);
    }
}

