/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.cache.CacheService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u4e1a\u52a1\u652f\u6491-\u7f13\u5b58")
public class AdminCacheController
extends SupportBaseController {
    @Resource
    private CacheService cacheService;

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7f13\u5b58 @author \u7f57\u4f0a")
    @GetMapping(value={"/cache/names"})
    @SaCheckPermission(value={"support:cache:keys"})
    public ResponseDTO<List<String>> cacheNames() {
        return ResponseDTO.ok((Object)this.cacheService.cacheNames());
    }

    @Operation(summary="\u79fb\u9664\u67d0\u4e2a\u7f13\u5b58 @author \u7f57\u4f0a")
    @GetMapping(value={"/cache/remove/{cacheName}"})
    @SaCheckPermission(value={"support:cache:delete"})
    public ResponseDTO<String> removeCache(@PathVariable String cacheName) {
        this.cacheService.removeCache(cacheName);
        return ResponseDTO.ok();
    }

    @Operation(summary="\u83b7\u53d6\u67d0\u4e2a\u7f13\u5b58\u7684\u6240\u6709key @author \u7f57\u4f0a")
    @GetMapping(value={"/cache/keys/{cacheName}"})
    @SaCheckPermission(value={"support:cache:keys"})
    public ResponseDTO<List<String>> cacheKeys(@PathVariable String cacheName) {
        return ResponseDTO.ok((Object)this.cacheService.cacheKey(cacheName));
    }
}

