/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.domain.ValidateList;
import net.lab1024.sa.base.module.support.changelog.domain.form.ChangeLogAddForm;
import net.lab1024.sa.base.module.support.changelog.domain.form.ChangeLogUpdateForm;
import net.lab1024.sa.base.module.support.changelog.service.ChangeLogService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u4e1a\u52a1\u652f\u6491-\u66f4\u65b0\u65e5\u5fd7")
public class AdminChangeLogController
extends SupportBaseController {
    @Resource
    private ChangeLogService changeLogService;

    @Operation(summary="\u6dfb\u52a0 @author \u5353\u5927")
    @PostMapping(value={"/changeLog/add"})
    @SaCheckPermission(value={"support:changeLog:add"})
    public ResponseDTO<String> add(@RequestBody @Valid ChangeLogAddForm addForm) {
        return this.changeLogService.add(addForm);
    }

    @Operation(summary="\u66f4\u65b0 @author \u5353\u5927")
    @PostMapping(value={"/changeLog/update"})
    @SaCheckPermission(value={"support:changeLog:update"})
    public ResponseDTO<String> update(@RequestBody @Valid ChangeLogUpdateForm updateForm) {
        return this.changeLogService.update(updateForm);
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664 @author \u5353\u5927")
    @PostMapping(value={"/changeLog/batchDelete"})
    @SaCheckPermission(value={"support:changeLog:batchDelete"})
    public ResponseDTO<String> batchDelete(@RequestBody ValidateList<Long> idList) {
        return this.changeLogService.batchDelete(idList);
    }

    @Operation(summary="\u5355\u4e2a\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/changeLog/delete/{changeLogId}"})
    @SaCheckPermission(value={"support:changeLog:delete"})
    public ResponseDTO<String> batchDelete(@PathVariable Long changeLogId) {
        return this.changeLogService.delete(changeLogId);
    }
}

