/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.config.ConfigService;
import net.lab1024.sa.base.module.support.config.domain.ConfigAddForm;
import net.lab1024.sa.base.module.support.config.domain.ConfigQueryForm;
import net.lab1024.sa.base.module.support.config.domain.ConfigUpdateForm;
import net.lab1024.sa.base.module.support.config.domain.ConfigVO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e1a\u52a1\u652f\u6491-\u7cfb\u7edf\u53c2\u6570")
@RestController
public class AdminConfigController
extends SupportBaseController {
    @Resource
    private ConfigService configService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7cfb\u7edf\u914d\u7f6e @author \u5353\u5927")
    @PostMapping(value={"/config/query"})
    @SaCheckPermission(value={"support:config:query"})
    public ResponseDTO<PageResult<ConfigVO>> queryConfigPage(@RequestBody @Valid ConfigQueryForm queryForm) {
        return this.configService.queryConfigPage(queryForm);
    }

    @Operation(summary="\u6dfb\u52a0\u914d\u7f6e\u53c2\u6570 @author \u5353\u5927")
    @PostMapping(value={"/config/add"})
    @SaCheckPermission(value={"support:config:add"})
    public ResponseDTO<String> addConfig(@RequestBody @Valid ConfigAddForm configAddForm) {
        return this.configService.add(configAddForm);
    }

    @Operation(summary="\u4fee\u6539\u914d\u7f6e\u53c2\u6570 @author \u5353\u5927")
    @PostMapping(value={"/config/update"})
    @SaCheckPermission(value={"support:config:update"})
    public ResponseDTO<String> updateConfig(@RequestBody @Valid ConfigUpdateForm updateForm) {
        return this.configService.updateConfig(updateForm);
    }
}

