/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.dict.domain.form.DictKeyAddForm;
import net.lab1024.sa.base.module.support.dict.domain.form.DictKeyQueryForm;
import net.lab1024.sa.base.module.support.dict.domain.form.DictKeyUpdateForm;
import net.lab1024.sa.base.module.support.dict.domain.form.DictValueAddForm;
import net.lab1024.sa.base.module.support.dict.domain.form.DictValueUpdateForm;
import net.lab1024.sa.base.module.support.dict.domain.vo.DictKeyVO;
import net.lab1024.sa.base.module.support.dict.service.DictCacheService;
import net.lab1024.sa.base.module.support.dict.service.DictService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e1a\u52a1\u652f\u6491-\u6570\u636e\u5b57\u5178")
@RestController
public class AdminDictController
extends SupportBaseController {
    @Resource
    private DictService dictService;
    @Resource
    private DictCacheService dictCacheService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u6570\u636e\u5b57\u5178KEY - @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/key/query"})
    public ResponseDTO<PageResult<DictKeyVO>> keyQuery(@Valid @RequestBody DictKeyQueryForm queryForm) {
        return this.dictService.keyQuery(queryForm);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178KEY-\u6dfb\u52a0- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/key/add"})
    @SaCheckPermission(value={"support:dict:add"})
    public ResponseDTO<String> keyAdd(@Valid @RequestBody DictKeyAddForm keyAddForm) {
        return this.dictService.keyAdd(keyAddForm);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178\u7f13\u5b58-\u5237\u65b0- @author \u7f57\u4f0a")
    @GetMapping(value={"/dict/cache/refresh"})
    @SaCheckPermission(value={"support:dict:refresh"})
    public ResponseDTO<String> cacheRefresh() {
        return this.dictCacheService.cacheRefresh();
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178Value-\u6dfb\u52a0- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/value/add"})
    public ResponseDTO<String> valueAdd(@Valid @RequestBody DictValueAddForm valueAddForm) {
        return this.dictService.valueAdd(valueAddForm);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178KEY-\u66f4\u65b0- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/key/edit"})
    @SaCheckPermission(value={"support:dict:edit"})
    public ResponseDTO<String> keyEdit(@Valid @RequestBody DictKeyUpdateForm keyUpdateForm) {
        return this.dictService.keyEdit(keyUpdateForm);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178Value-\u66f4\u65b0- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/value/edit"})
    public ResponseDTO<String> valueEdit(@Valid @RequestBody DictValueUpdateForm valueUpdateForm) {
        return this.dictService.valueEdit(valueUpdateForm);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178KEY-\u5220\u9664- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/key/delete"})
    @SaCheckPermission(value={"support:dict:delete"})
    public ResponseDTO<String> keyDelete(@RequestBody List<Long> keyIdList) {
        return this.dictService.keyDelete(keyIdList);
    }

    @Operation(summary="\u6570\u636e\u5b57\u5178Value-\u5220\u9664- @author \u7f57\u4f0a")
    @PostMapping(value={"/dict/value/delete"})
    public ResponseDTO<String> valueDelete(@RequestBody List<Long> valueIdList) {
        return this.dictService.valueDelete(valueIdList);
    }
}

