/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.helpdoc.domain.form.HelpDocAddForm;
import net.lab1024.sa.base.module.support.helpdoc.domain.form.HelpDocCatalogAddForm;
import net.lab1024.sa.base.module.support.helpdoc.domain.form.HelpDocCatalogUpdateForm;
import net.lab1024.sa.base.module.support.helpdoc.domain.form.HelpDocQueryForm;
import net.lab1024.sa.base.module.support.helpdoc.domain.form.HelpDocUpdateForm;
import net.lab1024.sa.base.module.support.helpdoc.domain.vo.HelpDocDetailVO;
import net.lab1024.sa.base.module.support.helpdoc.domain.vo.HelpDocVO;
import net.lab1024.sa.base.module.support.helpdoc.service.HelpDocCatalogService;
import net.lab1024.sa.base.module.support.helpdoc.service.HelpDocService;
import net.lab1024.sa.base.module.support.repeatsubmit.annoation.RepeatSubmit;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e1a\u52a1\u652f\u6491-\u5e2e\u52a9\u6587\u6863")
@RestController
public class AdminHelpDocController
extends SupportBaseController {
    @Resource
    private HelpDocService helpDocService;
    @Resource
    private HelpDocCatalogService helpDocCatalogService;

    @Operation(summary="\u5e2e\u52a9\u6587\u6863\u76ee\u5f55-\u6dfb\u52a0 @author \u5353\u5927")
    @PostMapping(value={"/helpDoc/helpDocCatalog/add"})
    public ResponseDTO<String> addHelpDocCatalog(@RequestBody @Valid HelpDocCatalogAddForm helpDocCatalogAddForm) {
        return this.helpDocCatalogService.add(helpDocCatalogAddForm);
    }

    @Operation(summary="\u5e2e\u52a9\u6587\u6863\u76ee\u5f55-\u66f4\u65b0 @author \u5353\u5927")
    @PostMapping(value={"/helpDoc/helpDocCatalog/update"})
    public ResponseDTO<String> updateHelpDocCatalog(@RequestBody @Valid HelpDocCatalogUpdateForm helpDocCatalogUpdateForm) {
        return this.helpDocCatalogService.update(helpDocCatalogUpdateForm);
    }

    @Operation(summary="\u5e2e\u52a9\u6587\u6863\u76ee\u5f55-\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/helpDoc/helpDocCatalog/delete/{helpDocCatalogId}"})
    public ResponseDTO<String> deleteHelpDocCatalog(@PathVariable Long helpDocCatalogId) {
        return this.helpDocCatalogService.delete(helpDocCatalogId);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u5206\u9875\u67e5\u8be2 @author \u5353\u5927")
    @PostMapping(value={"/helpDoc/query"})
    @SaCheckPermission(value={"support:helpDoc:query"})
    public ResponseDTO<PageResult<HelpDocVO>> query(@RequestBody @Valid HelpDocQueryForm queryForm) {
        return ResponseDTO.ok((Object)this.helpDocService.query(queryForm));
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u83b7\u53d6\u8be6\u60c5 @author \u5353\u5927")
    @GetMapping(value={"/helpDoc/getDetail/{helpDocId}"})
    @SaCheckPermission(value={"support:helpDoc:add"})
    public ResponseDTO<HelpDocDetailVO> getDetail(@PathVariable Long helpDocId) {
        return ResponseDTO.ok((Object)this.helpDocService.getDetail(helpDocId));
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u6dfb\u52a0 @author \u5353\u5927")
    @PostMapping(value={"/helpDoc/add"})
    @RepeatSubmit
    public ResponseDTO<String> add(@RequestBody @Valid HelpDocAddForm addForm) {
        return this.helpDocService.add(addForm);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u66f4\u65b0 @author \u5353\u5927")
    @PostMapping(value={"/helpDoc/update"})
    @RepeatSubmit
    public ResponseDTO<String> update(@RequestBody @Valid HelpDocUpdateForm updateForm) {
        return this.helpDocService.update(updateForm);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u5220\u9664 @author \u5353\u5927")
    @GetMapping(value={"/helpDoc/delete/{helpDocId}"})
    public ResponseDTO<String> delete(@PathVariable Long helpDocId) {
        return this.helpDocService.delete(helpDocId);
    }

    @Operation(summary="\u3010\u7ba1\u7406\u3011\u5e2e\u52a9\u6587\u6863-\u6839\u636e\u5173\u8054id\u67e5\u8be2 @author \u5353\u5927")
    @GetMapping(value={"/helpDoc/queryHelpDocByRelationId/{relationId}"})
    public ResponseDTO<List<HelpDocVO>> queryHelpDocByRelationId(@PathVariable Long relationId) {
        return ResponseDTO.ok((Object)this.helpDocService.queryHelpDocByRelationId(relationId));
    }
}

