/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.Resource;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.module.support.operatelog.OperateLogService;
import net.lab1024.sa.base.module.support.operatelog.domain.OperateLogQueryForm;
import net.lab1024.sa.base.module.support.operatelog.domain.OperateLogVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u4e1a\u52a1\u652f\u6491-\u7528\u6237\u64cd\u4f5c\u8bb0\u5f55")
public class AdminOperateLogController
extends SupportBaseController {
    @Resource
    private OperateLogService operateLogService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2 @author \u7f57\u4f0a")
    @PostMapping(value={"/operateLog/page/query"})
    @SaCheckPermission(value={"support:operateLog:query"})
    public ResponseDTO<PageResult<OperateLogVO>> queryByPage(@RequestBody OperateLogQueryForm queryForm) {
        return this.operateLogService.queryByPage(queryForm);
    }

    @Operation(summary="\u8be6\u60c5 @author \u7f57\u4f0a")
    @GetMapping(value={"/operateLog/detail/{operateLogId}"})
    @SaCheckPermission(value={"support:operateLog:detail"})
    public ResponseDTO<OperateLogVO> detail(@PathVariable Long operateLogId) {
        return this.operateLogService.detail(operateLogId);
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f @author \u5584\u9038")
    @PostMapping(value={"/operateLog/page/query/login"})
    public ResponseDTO<PageResult<OperateLogVO>> queryByPageLogin(@RequestBody OperateLogQueryForm queryForm) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        queryForm.setOperateUserId(requestUser.getUserId());
        queryForm.setOperateUserType(requestUser.getUserType().getValue());
        return this.operateLogService.queryByPage(queryForm);
    }
}

