/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.module.support.reload.ReloadService;
import net.lab1024.sa.base.module.support.reload.domain.ReloadForm;
import net.lab1024.sa.base.module.support.reload.domain.ReloadItemVO;
import net.lab1024.sa.base.module.support.reload.domain.ReloadResultVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u4e1a\u52a1\u652f\u6491-reload")
public class AdminReloadController
extends SupportBaseController {
    @Resource
    private ReloadService reloadService;

    @Operation(summary="\u67e5\u8be2reload\u5217\u8868 @author \u5f00\u4e91")
    @GetMapping(value={"/reload/query"})
    public ResponseDTO<List<ReloadItemVO>> query() {
        return this.reloadService.query();
    }

    @Operation(summary="\u83b7\u53d6reload result @author \u5f00\u4e91")
    @GetMapping(value={"/reload/result/{tag}"})
    @SaCheckPermission(value={"support:reload:result"})
    public ResponseDTO<List<ReloadResultVO>> queryReloadResult(@PathVariable(value="tag") String tag) {
        return this.reloadService.queryReloadItemResult(tag);
    }

    @Operation(summary="\u901a\u8fc7tag\u66f4\u65b0\u6807\u8bc6 @author \u5f00\u4e91")
    @PostMapping(value={"/reload/update"})
    @SaCheckPermission(value={"support:reload:update"})
    public ResponseDTO<String> updateByTag(@RequestBody @Valid ReloadForm reloadForm) {
        return this.reloadService.updateByTag(reloadForm);
    }
}

