/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import cn.dev33.satoken.annotation.SaCheckPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartEnumUtil;
import net.lab1024.sa.base.module.support.serialnumber.constant.SerialNumberIdEnum;
import net.lab1024.sa.base.module.support.serialnumber.dao.SerialNumberDao;
import net.lab1024.sa.base.module.support.serialnumber.domain.SerialNumberEntity;
import net.lab1024.sa.base.module.support.serialnumber.domain.SerialNumberGenerateForm;
import net.lab1024.sa.base.module.support.serialnumber.domain.SerialNumberRecordEntity;
import net.lab1024.sa.base.module.support.serialnumber.domain.SerialNumberRecordQueryForm;
import net.lab1024.sa.base.module.support.serialnumber.service.SerialNumberRecordService;
import net.lab1024.sa.base.module.support.serialnumber.service.SerialNumberService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e1a\u52a1\u652f\u6491-id\u751f\u6210\u5668")
@RestController
public class AdminSerialNumberController
extends SupportBaseController {
    @Resource
    private SerialNumberDao serialNumberDao;
    @Resource
    private SerialNumberService serialNumberService;
    @Resource
    private SerialNumberRecordService serialNumberRecordService;

    @Operation(summary="\u751f\u6210\u5355\u53f7 @author \u5353\u5927")
    @PostMapping(value={"/serialNumber/generate"})
    @SaCheckPermission(value={"support:serialNumber:generate"})
    public ResponseDTO<List<String>> generate(@RequestBody @Valid SerialNumberGenerateForm generateForm) {
        SerialNumberIdEnum serialNumberIdEnum = (SerialNumberIdEnum)SmartEnumUtil.getEnumByValue((Object)generateForm.getSerialNumberId(), SerialNumberIdEnum.class);
        if (null == serialNumberIdEnum) {
            return ResponseDTO.userErrorParam((String)("SerialNumberId\uff0c\u4e0d\u5b58\u5728" + generateForm.getSerialNumberId()));
        }
        return ResponseDTO.ok((Object)this.serialNumberService.generate(serialNumberIdEnum, generateForm.getCount().intValue()));
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u5355\u53f7\u5b9a\u4e49 @author \u5353\u5927")
    @GetMapping(value={"/serialNumber/all"})
    public ResponseDTO<List<SerialNumberEntity>> getAll() {
        return ResponseDTO.ok((Object)this.serialNumberDao.selectList(null));
    }

    @Operation(summary="\u83b7\u53d6\u751f\u6210\u8bb0\u5f55 @author \u5353\u5927")
    @PostMapping(value={"/serialNumber/queryRecord"})
    @SaCheckPermission(value={"support:serialNumber:record"})
    public ResponseDTO<PageResult<SerialNumberRecordEntity>> queryRecord(@RequestBody @Valid SerialNumberRecordQueryForm queryForm) {
        return ResponseDTO.ok((Object)this.serialNumberRecordService.query(queryForm));
    }
}

