/*
 * Decompiled with CFR 0.152.
 */
package net.lab1024.sa.admin.module.system.support;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import net.lab1024.sa.base.common.controller.SupportBaseController;
import net.lab1024.sa.base.common.domain.PageResult;
import net.lab1024.sa.base.common.domain.RequestUser;
import net.lab1024.sa.base.common.domain.ResponseDTO;
import net.lab1024.sa.base.common.util.SmartRequestUtil;
import net.lab1024.sa.base.module.support.job.api.SmartJobService;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobEnabledUpdateForm;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobExecuteForm;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobLogQueryForm;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobLogVO;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobQueryForm;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobUpdateForm;
import net.lab1024.sa.base.module.support.job.api.domain.SmartJobVO;
import net.lab1024.sa.base.module.support.job.config.SmartJobAutoConfiguration;
import net.lab1024.sa.base.module.support.repeatsubmit.annoation.RepeatSubmit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e1a\u52a1\u652f\u6491-\u5b9a\u65f6\u4efb\u52a1")
@RestController
@ConditionalOnBean(value={SmartJobAutoConfiguration.class})
public class AdminSmartJobController
extends SupportBaseController {
    @Autowired
    private SmartJobService jobService;

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u7acb\u5373\u6267\u884c @huke")
    @PostMapping(value={"/job/execute"})
    @RepeatSubmit
    public ResponseDTO<String> execute(@RequestBody @Valid SmartJobExecuteForm executeForm) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        executeForm.setUpdateName(requestUser.getUserName());
        return this.jobService.execute(executeForm);
    }

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u67e5\u8be2\u8be6\u60c5 @huke")
    @GetMapping(value={"/job/{jobId}"})
    public ResponseDTO<SmartJobVO> queryJobInfo(@PathVariable Integer jobId) {
        return this.jobService.queryJobInfo(jobId);
    }

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u5206\u9875\u67e5\u8be2 @huke")
    @PostMapping(value={"/job/query"})
    public ResponseDTO<PageResult<SmartJobVO>> queryJob(@RequestBody @Valid SmartJobQueryForm queryForm) {
        return this.jobService.queryJob(queryForm);
    }

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u66f4\u65b0-\u4efb\u52a1\u4fe1\u606f @huke")
    @PostMapping(value={"/job/update"})
    @RepeatSubmit
    public ResponseDTO<String> updateJob(@RequestBody @Valid SmartJobUpdateForm updateForm) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        updateForm.setUpdateName(requestUser.getUserName());
        return this.jobService.updateJob(updateForm);
    }

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u66f4\u65b0-\u5f00\u542f\u72b6\u6001 @huke")
    @PostMapping(value={"/job/update/enabled"})
    @RepeatSubmit
    public ResponseDTO<String> updateJobEnabled(@RequestBody @Valid SmartJobEnabledUpdateForm updateForm) {
        RequestUser requestUser = SmartRequestUtil.getRequestUser();
        updateForm.setUpdateName(requestUser.getUserName());
        return this.jobService.updateJobEnabled(updateForm);
    }

    @Operation(summary="\u5b9a\u65f6\u4efb\u52a1-\u6267\u884c\u8bb0\u5f55-\u5206\u9875\u67e5\u8be2 @huke")
    @PostMapping(value={"/job/log/query"})
    public ResponseDTO<PageResult<SmartJobLogVO>> queryJobLog(@RequestBody @Valid SmartJobLogQueryForm queryForm) {
        return this.jobService.queryJobLog(queryForm);
    }
}

